/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.13-MariaDB, for debian-linux-gnu (x86_64)
--
-- Host: localhost    Database: projectnow_
-- ------------------------------------------------------
-- Server version	10.11.13-MariaDB-0ubuntu0.24.04.1-log

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `ai_prompts`
--

DROP TABLE IF EXISTS `ai_prompts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ai_prompts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `category` varchar(255) NOT NULL,
  `prompt` longtext NOT NULL,
  `parameters` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`parameters`)),
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ai_prompts`
--

LOCK TABLES `ai_prompts` WRITE;
/*!40000 ALTER TABLE `ai_prompts` DISABLE KEYS */;
/*!40000 ALTER TABLE `ai_prompts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(255) NOT NULL,
  `value` mediumtext NOT NULL,
  `expiration` int(11) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(255) NOT NULL,
  `owner` varchar(255) NOT NULL,
  `expiration` int(11) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `campaign_details`
--

DROP TABLE IF EXISTS `campaign_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `campaign_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `contact_id` bigint(20) unsigned NOT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'pending',
  `sent_at` timestamp NULL DEFAULT NULL,
  `delivered_at` timestamp NULL DEFAULT NULL,
  `error_message` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `campaign_details_campaign_id_contact_id_unique` (`campaign_id`,`contact_id`),
  KEY `campaign_details_contact_id_foreign` (`contact_id`),
  CONSTRAINT `campaign_details_campaign_id_foreign` FOREIGN KEY (`campaign_id`) REFERENCES `campaigns` (`id`) ON DELETE CASCADE,
  CONSTRAINT `campaign_details_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `campaign_details`
--

LOCK TABLES `campaign_details` WRITE;
/*!40000 ALTER TABLE `campaign_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `campaign_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `campaigns`
--

DROP TABLE IF EXISTS `campaigns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `campaigns` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `description` longtext DEFAULT NULL,
  `status` enum('draft','active','paused','completed','failed') NOT NULL DEFAULT 'draft',
  `start_date` timestamp NULL DEFAULT NULL,
  `end_date` timestamp NULL DEFAULT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `campaigns_user_id_foreign` (`user_id`),
  CONSTRAINT `campaigns_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `campaigns`
--

LOCK TABLES `campaigns` WRITE;
/*!40000 ALTER TABLE `campaigns` DISABLE KEYS */;
/*!40000 ALTER TABLE `campaigns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `canned_replies`
--

DROP TABLE IF EXISTS `canned_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `canned_replies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL,
  `content` longtext NOT NULL,
  `category` varchar(255) DEFAULT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `canned_replies_user_id_foreign` (`user_id`),
  CONSTRAINT `canned_replies_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `canned_replies`
--

LOCK TABLES `canned_replies` WRITE;
/*!40000 ALTER TABLE `canned_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `canned_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chat_messages`
--

DROP TABLE IF EXISTS `chat_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `chat_messages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `chat_id` bigint(20) unsigned NOT NULL,
  `sender_type` enum('contact','user','bot') NOT NULL,
  `sender_id` bigint(20) unsigned NOT NULL,
  `message` longtext NOT NULL,
  `attachments` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`attachments`)),
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `time_sent` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_messages_chat_id_foreign` (`chat_id`),
  CONSTRAINT `chat_messages_chat_id_foreign` FOREIGN KEY (`chat_id`) REFERENCES `chats` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chat_messages`
--

LOCK TABLES `chat_messages` WRITE;
/*!40000 ALTER TABLE `chat_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `chat_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chats`
--

DROP TABLE IF EXISTS `chats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `chats` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `platform` varchar(255) NOT NULL,
  `status` enum('open','closed','pending') NOT NULL DEFAULT 'open',
  `last_message_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chats_contact_id_foreign` (`contact_id`),
  KEY `chats_user_id_foreign` (`user_id`),
  CONSTRAINT `chats_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chats_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chats`
--

LOCK TABLES `chats` WRITE;
/*!40000 ALTER TABLE `chats` DISABLE KEYS */;
/*!40000 ALTER TABLE `chats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_notes`
--

DROP TABLE IF EXISTS `contact_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `note` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contact_notes_contact_id_foreign` (`contact_id`),
  KEY `contact_notes_user_id_foreign` (`user_id`),
  CONSTRAINT `contact_notes_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contact_notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_notes`
--

LOCK TABLES `contact_notes` WRITE;
/*!40000 ALTER TABLE `contact_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `firstname` varchar(255) NOT NULL,
  `lastname` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone_number` varchar(255) DEFAULT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `source_id` bigint(20) unsigned NOT NULL,
  `status_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `notes` longtext DEFAULT NULL,
  `custom_fields` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`custom_fields`)),
  `tags` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`tags`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_source_id_foreign` (`source_id`),
  KEY `contacts_status_id_foreign` (`status_id`),
  KEY `contacts_user_id_foreign` (`user_id`),
  KEY `contacts_email_index` (`email`),
  KEY `contacts_phone_number_index` (`phone_number`),
  CONSTRAINT `contacts_source_id_foreign` FOREIGN KEY (`source_id`) REFERENCES `sources` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_status_id_foreign` FOREIGN KEY (`status_id`) REFERENCES `statuses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `email_templates`
--

DROP TABLE IF EXISTS `email_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `message` longtext NOT NULL,
  `slug` varchar(255) NOT NULL,
  `merge_fields_groups` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`merge_fields_groups`)),
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email_templates_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_templates`
--

LOCK TABLES `email_templates` WRITE;
/*!40000 ALTER TABLE `email_templates` DISABLE KEYS */;
INSERT INTO `email_templates` VALUES
(1,'SMTP Test Mail','SMTP Test Mail','<p>This is a test email to confirm that your SMTP settings are correctly configured.</p><p>If you have received this email, your SMTP setup is working properly.</p><p>If you did not request this test or face any issues, please review your SMTP configuration or contact support at <a href=\"mailto:{company_email}\">{company_email}</a>.</p>','smtp-test-mail','[\"other-group\"]',1,'2025-10-25 18:40:14','2025-10-25 18:40:14'),
(2,'Email Confirmation','Email Confirmation','<p>Thank you for signing up with {site_name}, {first_name} {last_name}!</p><p>We\'re thrilled to have you on board. Before you get started, we need to verify your email address to ensure the security of your account.</p><p>Please click the button below to verify your email:</p>','email-confirmation','[\"other-group\",\"user-group\"]',1,'2025-10-25 18:40:14','2025-10-25 18:40:14'),
(3,'Welcome Email','Welcome to {site_name}!','<p>Dear {first_name} {last_name},</p><p>Welcome to {site_name}! We\'re excited to have you on board. 🚀</p><p>Get ready to explore our amazing features and make your life easier.</p><p>If you have any questions, our support team at <a href=\"mailto:{company_email}\">{company_email}</a> is always here to help.</p><p>Start your journey here: <a href=\"{base_url}\">{base_url}</a></p><p>Looking forward to seeing you thrive!</p>','welcome-mail','[\"other-group\",\"user-group\"]',1,'2025-10-25 18:40:14','2025-10-25 18:40:14'),
(4,'Password Reset','Password Reset Request','<p>Hello {first_name} {last_name},</p><p>We received a request to reset your password for your {site_name} account.</p><p>If you made this request, click the button below to reset your password:</p><p><a href=\"{reset_link}\">Reset Password</a></p><p>If you did not request a password reset, please ignore this email or contact support at <a href=\"mailto:{company_email}\">{company_email}</a>.</p>','password-reset','[\"other-group\",\"user-group\"]',1,'2025-10-25 18:40:14','2025-10-25 18:40:14'),
(5,'New Contact Assigned','📌 New Contact Assigned to You','<p>Hi {first_name} {last_name},</p><p>A new contact has been assigned to you. Here are the details:</p><ul><li><strong>Contact Name:</strong> {contact_first_name} {contact_last_name}</li><li><strong>Email:</strong> {contact_email}</li><li><strong>Phone:</strong> {contact_phone_number}</li><li><strong>Assigned By:</strong> {assigned_by}</li></ul><p>Please reach out to them promptly and ensure a smooth follow-up.</p><p>If you have any questions, feel free to get in touch.</p><p><strong>Best regards,</strong><br>{site_name}</p>','new-contact-assigned','[\"other-group\",\"user-group\",\"contact-group\"]',1,'2025-10-25 18:40:14','2025-10-25 18:40:14');
/*!40000 ALTER TABLE `email_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `job_batches`
--

DROP TABLE IF EXISTS `job_batches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `job_batches` (
  `id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` longtext NOT NULL,
  `options` mediumtext DEFAULT NULL,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `job_batches`
--

LOCK TABLES `job_batches` WRITE;
/*!40000 ALTER TABLE `job_batches` DISABLE KEYS */;
/*!40000 ALTER TABLE `job_batches` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `code` varchar(5) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `languages_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES
(1,'English','en',1,'2025-10-25 18:37:13','2025-10-25 18:37:13');
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `message_bots`
--

DROP TABLE IF EXISTS `message_bots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `message_bots` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` longtext DEFAULT NULL,
  `triggers` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`triggers`)),
  `responses` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`responses`)),
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `message_bots_user_id_foreign` (`user_id`),
  CONSTRAINT `message_bots_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `message_bots`
--

LOCK TABLES `message_bots` WRITE;
/*!40000 ALTER TABLE `message_bots` DISABLE KEYS */;
/*!40000 ALTER TABLE `message_bots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES
(1,'0001_01_01_000000_create_users_table',1),
(2,'0001_01_01_000001_create_cache_table',1),
(3,'0001_01_01_000002_create_jobs_table',1),
(4,'2022_12_14_083707_create_settings_table',1),
(5,'2025_01_01_000000_create_sources_table',1),
(6,'2025_01_01_000001_create_statuses_table',1),
(7,'2025_01_01_000002_create_email_templates_table',1),
(8,'2025_01_01_000003_create_languages_table',1),
(9,'2025_01_01_000004_create_contacts_table',1),
(10,'2025_01_01_000005_create_campaigns_table',1),
(11,'2025_01_01_000006_create_campaign_details_table',1),
(12,'2025_01_01_000007_create_chat_tables',1),
(13,'2025_01_01_000008_create_misc_tables',1),
(14,'2025_01_01_000009_create_communication_tables',1),
(15,'2025_01_01_000010_create_bot_and_logs_tables',1),
(16,'2025_01_27_080617_whatsapp_settings',1),
(17,'2025_01_27_121905_create_cron_job_settings',1),
(18,'2025_01_27_122402_create_email_settings',1),
(19,'2025_01_27_124528_create_general_settings',1),
(20,'2025_01_27_125455_create_re_captcha_settings',1),
(21,'2025_01_27_132610_create_seo_settings',1),
(22,'2025_01_27_133221_announcement_settings',1),
(23,'2025_01_28_071849_create_whats_mark_settings',1),
(24,'2025_01_29_113358_create_pusher_settings',1),
(25,'2025_01_30_070038_create_permission_tables',1),
(26,'2025_02_08_093028_create_api_settings',1),
(27,'2025_02_17_181430_create_database_backup_settings',1),
(28,'2025_02_19_175157_create_webhook_settings',1),
(29,'2025_03_02_083707_alter_users_table',1),
(30,'2025_04_10_133415_update_cron_job_settings',1),
(31,'2025_04_18_114056_create_validate_settings',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `model_has_permissions`
--

DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `model_has_permissions`
--

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `model_has_roles`
--

DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_roles` (
  `role_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `model_has_roles`
--

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notifications`
--

DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `notifications` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `notifiable_type` varchar(255) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_user_id_foreign` (`user_id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`),
  CONSTRAINT `notifications_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notifications`
--

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permissions`
--

DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permissions`
--

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES
(1,'source.view','web',NULL,NULL),
(2,'source.create','web',NULL,NULL),
(3,'source.edit','web',NULL,NULL),
(4,'source.delete','web',NULL,NULL),
(5,'ai_prompt.view','web',NULL,NULL),
(6,'ai_prompt.create','web',NULL,NULL),
(7,'ai_prompt.edit','web',NULL,NULL),
(8,'ai_prompt.delete','web',NULL,NULL),
(9,'canned_reply.view','web',NULL,NULL),
(10,'canned_reply.create','web',NULL,NULL),
(11,'canned_reply.edit','web',NULL,NULL),
(12,'canned_reply.delete','web',NULL,NULL),
(13,'connect_account.view','web',NULL,NULL),
(14,'connect_account.connect','web',NULL,NULL),
(15,'connect_account.disconnect','web',NULL,NULL),
(16,'message_bot.view','web',NULL,NULL),
(17,'message_bot.create','web',NULL,NULL),
(18,'message_bot.edit','web',NULL,NULL),
(19,'message_bot.delete','web',NULL,NULL),
(20,'message_bot.clone','web',NULL,NULL),
(21,'template_bot.view','web',NULL,NULL),
(22,'template_bot.create','web',NULL,NULL),
(23,'template_bot.edit','web',NULL,NULL),
(24,'template_bot.delete','web',NULL,NULL),
(25,'template_bot.clone','web',NULL,NULL),
(26,'template.view','web',NULL,NULL),
(27,'template.load_template','web',NULL,NULL),
(28,'campaigns.view','web',NULL,NULL),
(29,'campaigns.create','web',NULL,NULL),
(30,'campaigns.edit','web',NULL,NULL),
(31,'campaigns.delete','web',NULL,NULL),
(32,'campaigns.show_campaign','web',NULL,NULL),
(33,'chat.view','web',NULL,NULL),
(34,'chat.read_only','web',NULL,NULL),
(35,'activity_log.view','web',NULL,NULL),
(36,'activity_log.delete','web',NULL,NULL),
(37,'whatsmark_settings.view','web',NULL,NULL),
(38,'whatsmark_settings.edit','web',NULL,NULL),
(39,'bulk_campaigns.send','web',NULL,NULL),
(40,'role.view','web',NULL,NULL),
(41,'role.create','web',NULL,NULL),
(42,'role.edit','web',NULL,NULL),
(43,'role.delete','web',NULL,NULL),
(44,'status.view','web',NULL,NULL),
(45,'status.create','web',NULL,NULL),
(46,'status.edit','web',NULL,NULL),
(47,'status.delete','web',NULL,NULL),
(48,'contact.view','web',NULL,NULL),
(49,'contact.create','web',NULL,NULL),
(50,'contact.edit','web',NULL,NULL),
(51,'contact.delete','web',NULL,NULL),
(52,'contact.bulk_import','web',NULL,NULL),
(53,'system_settings.view','web',NULL,NULL),
(54,'system_settings.edit','web',NULL,NULL),
(55,'user.view','web',NULL,NULL),
(56,'user.create','web',NULL,NULL),
(57,'user.edit','web',NULL,NULL),
(58,'user.delete','web',NULL,NULL),
(59,'email_template.view','web',NULL,NULL),
(60,'email_template.edit','web',NULL,NULL);
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pusher_notifications`
--

DROP TABLE IF EXISTS `pusher_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `pusher_notifications` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `channel` varchar(255) NOT NULL,
  `event` varchar(255) NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`data`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pusher_notifications_user_id_foreign` (`user_id`),
  CONSTRAINT `pusher_notifications_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pusher_notifications`
--

LOCK TABLES `pusher_notifications` WRITE;
/*!40000 ALTER TABLE `pusher_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `pusher_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_has_permissions`
--

DROP TABLE IF EXISTS `role_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `role_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_has_permissions`
--

LOCK TABLES `role_has_permissions` WRITE;
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(255) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `payload` longtext NOT NULL,
  `last_activity` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
INSERT INTO `sessions` VALUES
('DuYp70zXRVgAA3E6xCqxkjoFCwDr5XsF0glbCXGg',NULL,'89.150.152.198','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36','YToxMTp7czo2OiJfdG9rZW4iO3M6NDA6InpoeDJkN2U3VFV3NGg5TGpYNDZZUjBaSFZDZ1Q0VWI5bmlTSXEzaVEiO3M6OToiX3ByZXZpb3VzIjthOjE6e3M6MzoidXJsIjtzOjM2OiJodHRwczovL3Byb2plY3Rub3cucnVuLnBsYWNlL2luc3RhbGwiO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX1zOjEyOiJsaWNlbnNlX2RhdGEiO2E6Nzp7czo4OiJ1c2VybmFtZSI7czoxMToic2dzZWdzZWdzZWciO3M6MTM6InB1cmNoYXNlX2NvZGUiO3M6NToic2dzZWciO3M6ODoidmVyaWZpZWQiO2I6MTtzOjc6ImRldGFpbHMiO2E6MTp7czoxNToic3VwcG9ydGVkX3VudGlsIjtzOjEwOiIyMDk5LTEyLTMxIjt9czo1OiJ0b2tlbiI7czoyMzoiYnlwYXNzX3Rva2VuXzE3NjE0MjQ2MTQiO3M6MTU6InZlcmlmaWNhdGlvbl9pZCI7czoyMDoiYnlwYXNzX2lkXzE3NjE0MjQ2MTQiO3M6MTM6InN1cHBvcnRfdW50aWwiO3M6MTA6IjIwOTktMTItMzEiO31zOjE1OiJhZG1pbl9maXJzdG5hbWUiO3M6NDoibGFycyI7czoxNDoiYWRtaW5fbGFzdG5hbWUiO3M6NDoia2pzciI7czoxMToiYWRtaW5fZW1haWwiO3M6MTQ6ImFkbWluQG1haWwuY29tIjtzOjE0OiJhZG1pbl9wYXNzd29yZCI7czo5OiIuSGVqc2ExMjMiO3M6MTQ6ImFkbWluX3RpbWV6b25lIjtzOjM6IlVUQyI7czoyMjoiUEhQREVCVUdCQVJfU1RBQ0tfREFUQSI7YToxOntzOjI2OiIwMUs4RUhKRzBOMFhWVEhKQzU4NzlFMUFRUyI7Tjt9czo3OiJjb3VudHJ5IjtzOjI6IjE1Ijt9',1761424785),
('FstAyUbSPtOQ2Kbfo7UzBDSZRRMibKizvaGoAl69',NULL,'89.150.152.198','Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:144.0) Gecko/20100101 Firefox/144.0','YTo0OntzOjY6Il90b2tlbiI7czo0MDoiUENZTjgwbW9XbGFYOXdEZGJqM21xM1VPRGZ1TEcxZFJPWU01anZRdSI7czoyMjoiUEhQREVCVUdCQVJfU1RBQ0tfREFUQSI7YTowOnt9czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6Mjg6Imh0dHBzOi8vcHJvamVjdG5vdy5ydW4ucGxhY2UiO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX19',1761427980),
('IknvmLAVm6BpWbxJ6AJ4a34LuKGPkOjunOd89E8D',1,'89.150.152.198','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36','YToxMjp7czo2OiJfdG9rZW4iO3M6NDA6Ill4Z3Z3cFdiNTJsckR6SlRyVWZDUFcyWkpuU2ZOUGN3d055MkN2OHYiO3M6OToiX3ByZXZpb3VzIjthOjE6e3M6MzoidXJsIjtzOjM0OiJodHRwczovL3Byb2plY3Rub3cucnVuLnBsYWNlL2FkbWluIjt9czo2OiJfZmxhc2giO2E6Mjp7czozOiJvbGQiO2E6MDp7fXM6MzoibmV3IjthOjA6e319czoxMjoibGljZW5zZV9kYXRhIjthOjc6e3M6ODoidXNlcm5hbWUiO3M6NToiYWVmYWYiO3M6MTM6InB1cmNoYXNlX2NvZGUiO3M6ODoiamZzZWdzZWciO3M6ODoidmVyaWZpZWQiO2I6MTtzOjc6ImRldGFpbHMiO2E6MTp7czoxNToic3VwcG9ydGVkX3VudGlsIjtzOjEwOiIyMDk5LTEyLTMxIjt9czo1OiJ0b2tlbiI7czo0NDoid2hhdHNtYXJrX2luc3RhbGxlZF9Zbmx3WVhOelh6RTNOakUwTWpRM09UST0iO3M6MTU6InZlcmlmaWNhdGlvbl9pZCI7czo0MToid2hhdHNtYXJrX2lkX2RtVnlhV1pwWldSZk1UYzJNVFF5TkRjNU1nPT0iO3M6MTM6InN1cHBvcnRfdW50aWwiO3M6MTA6IjIwOTktMTItMzEiO31zOjE1OiJhZG1pbl9maXJzdG5hbWUiO3M6MTA6ImFzZGluYXNpZG4iO3M6MTQ6ImFkbWluX2xhc3RuYW1lIjtzOjEwOiJhc2ZuaWFud2ZpIjtzOjExOiJhZG1pbl9lbWFpbCI7czoxNDoiYWRtaW5AbWFpbC5jb20iO3M6MTQ6ImFkbWluX3Bhc3N3b3JkIjtzOjk6Ii5IZWpzYTEyMyI7czoxNDoiYWRtaW5fdGltZXpvbmUiO3M6MzoiVVRDIjtzOjUwOiJsb2dpbl93ZWJfNTliYTM2YWRkYzJiMmY5NDAxNTgwZjAxNGM3ZjU4ZWE0ZTMwOTg5ZCI7aToxO3M6NjoibG9jYWxlIjtzOjI6ImVuIjtzOjIyOiJQSFBERUJVR0JBUl9TVEFDS19EQVRBIjthOjA6e319',1761428126),
('nhnthGiMkTaINLCZ2rcGP6QdunHz5HembWZqkkmJ',NULL,'89.150.152.198','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36','YTo1OntzOjY6Il90b2tlbiI7czo0MDoiT3BzSFhrQ2NSVXJ4Q0x3ZUt6WnVIYVNmNUJqQnFBZnBnOXYxNUdaOSI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6MzY6Imh0dHBzOi8vcHJvamVjdG5vdy5ydW4ucGxhY2UvaW5zdGFsbCI7fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fXM6MTI6ImxpY2Vuc2VfZGF0YSI7YTo3OntzOjg6InVzZXJuYW1lIjtzOjc6ImZhc2Rmc2QiO3M6MTM6InB1cmNoYXNlX2NvZGUiO3M6Njoic2Rnc2RnIjtzOjg6InZlcmlmaWVkIjtiOjE7czo3OiJkZXRhaWxzIjthOjE6e3M6MTU6InN1cHBvcnRlZF91bnRpbCI7czoxMDoiMjA5OS0xMi0zMSI7fXM6NToidG9rZW4iO3M6MjM6ImJ5cGFzc190b2tlbl8xNzYxNDIzNTI1IjtzOjE1OiJ2ZXJpZmljYXRpb25faWQiO3M6MjA6ImJ5cGFzc19pZF8xNzYxNDIzNTI1IjtzOjEzOiJzdXBwb3J0X3VudGlsIjtzOjEwOiIyMDk5LTEyLTMxIjt9czoyMjoiUEhQREVCVUdCQVJfU1RBQ0tfREFUQSI7YTowOnt9fQ==',1761423526),
('XBk3QqRbqLs4kzAcZ0DC6J3jjAROvkdDgxqhrZaY',1,'89.150.152.198','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36','YTo1OntzOjY6Il90b2tlbiI7czo0MDoibjdWbVEyZ0F3MENqblNUTGV6aWdaOHVESWdZbGRqeFFEaGtxWEYxZCI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6MzQ6Imh0dHBzOi8vcHJvamVjdG5vdy5ydW4ucGxhY2UvYWRtaW4iO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX1zOjUwOiJsb2dpbl93ZWJfNTliYTM2YWRkYzJiMmY5NDAxNTgwZjAxNGM3ZjU4ZWE0ZTMwOTg5ZCI7aToxO3M6NjoibG9jYWxlIjtzOjI6ImVuIjt9',1761427574),
('xEV5uUgrcrNSogeIOYay5YLzDKLZITOC5HM6wQCA',1,'89.150.152.198','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36','YTo3OntzOjY6Il90b2tlbiI7czo0MDoiclhuNWwzVjAwOWU5cmp1SlczYTU2akJ6RFc0eTliRW9Nc052dzFtQSI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6MzQ6Imh0dHBzOi8vcHJvamVjdG5vdy5ydW4ucGxhY2UvYWRtaW4iO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX1zOjM6InVybCI7YTowOnt9czo1MDoibG9naW5fd2ViXzU5YmEzNmFkZGMyYjJmOTQwMTU4MGYwMTRjN2Y1OGVhNGUzMDk4OWQiO2k6MTtzOjY6ImxvY2FsZSI7czoyOiJlbiI7czoyMjoiUEhQREVCVUdCQVJfU1RBQ0tfREFUQSI7YTowOnt9fQ==',1761426338);
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `locked` tinyint(1) NOT NULL DEFAULT 0,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`payload`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_group_name_unique` (`group`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES
(1,'whatsapp','wm_fb_app_id',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(2,'whatsapp','wm_fb_app_secret',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(3,'whatsapp','wm_business_account_id',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(4,'whatsapp','wm_access_token',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(5,'whatsapp','wm_default_phone_number',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(6,'whatsapp','wm_default_phone_number_id',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(7,'whatsapp','wm_health_check_time',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(8,'whatsapp','wm_health_data',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(9,'whatsapp','wm_profile_picture_url',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(10,'whatsapp','is_webhook_connected',0,'\"0\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(11,'whatsapp','is_whatsmark_connected',0,'\"0\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(12,'whatsapp','api_version',0,'\"v21.0\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(13,'whatsapp','daily_limit',0,'1000','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(14,'whatsapp','webhook_verify_token',0,'\"mxK0ywW6dLzwGiCk\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(15,'whatsapp','queue',0,'\"{\\\"name\\\":\\\"whatsapp-messages\\\",\\\"connection\\\":\\\"redis\\\",\\\"retry_after\\\":180,\\\"timeout\\\":60}\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(16,'whatsapp','paths',0,'\"{\\\"qrcodes\\\":\\\"\\\\\\/var\\\\\\/www\\\\\\/vhosts\\\\\\/projectnow.run.place\\\\\\/httpdocs\\\\\\/storage\\\\\\/app\\\\\\/public\\\\\\/whatsapp\\\\\\/qrcodes\\\",\\\"media\\\":\\\"\\\\\\/var\\\\\\/www\\\\\\/vhosts\\\\\\/projectnow.run.place\\\\\\/httpdocs\\\\\\/storage\\\\\\/app\\\\\\/public\\\\\\/whatsapp\\\\\\/media\\\"}\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(17,'whatsapp','logging',0,'\"{\\\"channel\\\":\\\"whatsapp\\\",\\\"detailed\\\":true}\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(18,'cron-job','last_cron_run',0,'false','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(19,'email','mailer',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(20,'email','smtp_port',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(21,'email','smtp_username',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(22,'email','smtp_password',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(23,'email','smtp_encryption',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(24,'email','sender_name',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(25,'email','sender_email',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(26,'email','smtp_host',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(27,'general','site_name',0,'\"Whatsmark\"','2025-10-25 18:37:12','2025-10-25 18:40:13'),
(28,'general','site_description',0,'\"Whatsapp marketing website\"','2025-10-25 18:37:12','2025-10-25 18:40:13'),
(29,'general','timezone',0,'\"UTC\"','2025-10-25 18:37:12','2025-10-25 18:40:13'),
(30,'general','date_format',0,'\"d-m-Y\"','2025-10-25 18:37:12','2025-10-25 18:40:13'),
(31,'general','time_format',0,'\"12\"','2025-10-25 18:37:12','2025-10-25 18:40:13'),
(32,'general','site_logo',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:40:13'),
(33,'general','favicon',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:40:13'),
(34,'general','cover_page_image',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:40:13'),
(35,'general','site_dark_logo',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:40:13'),
(36,'general','active_language',0,'\"en\"','2025-10-25 18:37:12','2025-10-25 18:40:13'),
(37,'re-captcha','isReCaptchaEnable',0,'false','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(38,'re-captcha','site_key',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(39,'re-captcha','secret_key',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(40,'seo','meta_title',0,'\"WhatsMark\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(41,'seo','meta_description',0,'\"WhatsMark\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(42,'announcement','isEnable',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(43,'announcement','message',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(44,'announcement','link',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(45,'announcement','link_text',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(46,'announcement','background_color',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(47,'announcement','link_text_color',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(48,'announcement','message_color',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(49,'whats-mark','auto_lead_enabled',0,'false','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(50,'whats-mark','lead_status',0,'null','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(51,'whats-mark','lead_source',0,'null','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(52,'whats-mark','lead_assigned_to',0,'null','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(53,'whats-mark','stop_bots_keyword',0,'[]','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(54,'whats-mark','restart_bots_after',0,'null','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(55,'whats-mark','enable_webhook_resend',0,'false','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(56,'whats-mark','webhook_resend_method',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(57,'whats-mark','whatsapp_data_resend_to',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(58,'whats-mark','only_agents_can_chat',0,'false','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(59,'whats-mark','enable_chat_notification_sound',0,'false','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(60,'whats-mark','enable_openai_in_chat',0,'false','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(61,'whats-mark','openai_secret_key',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(62,'whats-mark','chat_model',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(63,'whats-mark','is_open_ai_key_verify',0,'false','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(64,'whats-mark','enable_auto_clear_chat',0,'false','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(65,'whats-mark','auto_clear_history_time',0,'null','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(66,'whats-mark','wm_version',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(67,'whats-mark','wm_verification_id',0,'\"d2hhdHNtYXJrX2lkX2RtVnlhV1pwWldSZk1UYzJNVFF5TkRjNU1nPT0=\"','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(68,'whats-mark','wm_verification_token',0,'\"d2hhdHNtYXJrX2luc3RhbGxlZF9Zbmx3WVhOelh6RTNOakUwTWpRM09UST0=|whatsmark_installed_YnlwYXNzXzE3NjE0MjQ3OTI=\"','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(69,'whats-mark','wm_last_verification',0,'\"1761424792\"','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(70,'whats-mark','wm_support_until',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(71,'pusher','app_id',0,'null','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(72,'pusher','app_key',0,'null','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(73,'pusher','app_secret',0,'null','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(74,'pusher','cluster',0,'\"ap2\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(75,'pusher','real_time_notify',0,'false','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(76,'pusher','desk_notify',0,'false','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(77,'pusher','dismiss_desk_notification',0,'5','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(78,'api','enabled',0,'false','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(79,'api','token',0,'null','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(80,'api','token_generated_at',0,'null','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(81,'api','last_used_at',0,'null','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(82,'api','rate_limit_max',0,'null','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(83,'api','rate_limit_decay',0,'null','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(84,'api','abilities',0,'[\"contacts.create\",\"contacts.read\",\"contacts.update\",\"contacts.delete\",\"statuses.create\",\"statuses.read\",\"statuses.update\",\"statuses.delete\",\"sources.create\",\"sources.read\",\"sources.update\",\"sources.delete\"]','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(85,'database-backup','backup_frequency',0,'\"daily\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(86,'database-backup','retention_count',0,'5','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(87,'database-backup','backup_time',0,'\"00:00\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(88,'database-backup','last_backup_at',0,'null','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(89,'database-backup','backup_enabled',0,'true','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(90,'webhook','webhook_enabled',0,'false','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(91,'webhook','webhook_url',0,'\"\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(92,'webhook','contacts_actions',0,'{\"create\":false,\"read\":false,\"update\":false,\"delete\":false}','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(93,'webhook','status_actions',0,'{\"create\":false,\"read\":false,\"update\":false,\"delete\":false}','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(94,'webhook','source_actions',0,'{\"create\":false,\"read\":false,\"update\":false,\"delete\":false}','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(95,'cron-job','status',0,'\"unknown\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(96,'cron-job','last_cron_stats',0,'\"{}\"','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(97,'cron-job','last_execution_time',0,'0','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(98,'cron-job','job_start_time',0,'0','2025-10-25 18:37:12','2025-10-25 18:37:12'),
(99,'whats-mark','wm_validate',0,'true','2025-10-25 18:37:12','2025-10-25 18:39:52'),
(100,'whats-mark','whatsmark_latest_version',0,'\"1.0.0\"','2025-10-25 18:37:12','2025-10-25 18:39:52');
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sources`
--

DROP TABLE IF EXISTS `sources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sources` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sources`
--

LOCK TABLES `sources` WRITE;
/*!40000 ALTER TABLE `sources` DISABLE KEYS */;
INSERT INTO `sources` VALUES
(1,'facebook','2025-10-25 18:37:13','2025-10-25 18:37:13'),
(2,'whatsapp','2025-10-25 18:37:13','2025-10-25 18:37:13'),
(3,'saas','2025-10-25 18:37:13','2025-10-25 18:37:13');
/*!40000 ALTER TABLE `sources` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `statuses`
--

DROP TABLE IF EXISTS `statuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `statuses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `color` varchar(7) DEFAULT NULL,
  `isdefault` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `statuses`
--

LOCK TABLES `statuses` WRITE;
/*!40000 ALTER TABLE `statuses` DISABLE KEYS */;
INSERT INTO `statuses` VALUES
(1,'New','#4CAF50',1,'2025-10-25 18:37:13','2025-10-25 18:37:13'),
(2,'In Progress','#2196F3',0,'2025-10-25 18:37:13','2025-10-25 18:37:13'),
(3,'Contacted','#FFC107',0,'2025-10-25 18:37:13','2025-10-25 18:37:13'),
(4,'Qualified','#9C27B0',0,'2025-10-25 18:37:13','2025-10-25 18:37:13'),
(5,'Closed','#F44336',0,'2025-10-25 18:37:13','2025-10-25 18:37:13');
/*!40000 ALTER TABLE `statuses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `template_bots`
--

DROP TABLE IF EXISTS `template_bots`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `template_bots` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `message_bot_id` bigint(20) unsigned NOT NULL,
  `template_type` varchar(255) NOT NULL,
  `template_content` longtext NOT NULL,
  `variables` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`variables`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `template_bots_message_bot_id_foreign` (`message_bot_id`),
  CONSTRAINT `template_bots_message_bot_id_foreign` FOREIGN KEY (`message_bot_id`) REFERENCES `message_bots` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `template_bots`
--

LOCK TABLES `template_bots` WRITE;
/*!40000 ALTER TABLE `template_bots` DISABLE KEYS */;
/*!40000 ALTER TABLE `template_bots` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `test_users`
--

DROP TABLE IF EXISTS `test_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `test_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `test_users`
--

LOCK TABLES `test_users` WRITE;
/*!40000 ALTER TABLE `test_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `test_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `firstname` varchar(255) NOT NULL,
  `lastname` varchar(255) NOT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `default_language` varchar(255) DEFAULT NULL,
  `profile_image_url` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `last_login` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `role_id` bigint(20) unsigned DEFAULT NULL,
  `is_admin` int(11) NOT NULL DEFAULT 0,
  `send_welcome_mail` tinyint(1) NOT NULL DEFAULT 0,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `banned_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  KEY `users_role_id_foreign` (`role_id`),
  CONSTRAINT `users_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES
(1,'asdinasidn','asfnianwfi',NULL,NULL,NULL,'admin@mail.com','2025-10-25 18:40:13','2025-10-25 19:13:33','$2y$12$wHQSCC83uFMzxJAabLZa/.y8wx9tZqCjp7J3iwJmND5ukdgcS53Ji',NULL,1,0,1,NULL,'2025-10-25 18:37:12','2025-10-25 19:13:33',NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `webhook_logs`
--

DROP TABLE IF EXISTS `webhook_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `webhook_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  `method` varchar(255) NOT NULL,
  `headers` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`headers`)),
  `payload` longtext NOT NULL,
  `response` longtext DEFAULT NULL,
  `status_code` int(11) DEFAULT NULL,
  `response_time` int(11) DEFAULT NULL,
  `status` enum('pending','success','failed') NOT NULL DEFAULT 'pending',
  `error_message` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `webhook_logs`
--

LOCK TABLES `webhook_logs` WRITE;
/*!40000 ALTER TABLE `webhook_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `webhook_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `whatsapp_templates`
--

DROP TABLE IF EXISTS `whatsapp_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `whatsapp_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `language` varchar(5) NOT NULL DEFAULT 'en',
  `components` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`components`)),
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `whatsapp_templates`
--

LOCK TABLES `whatsapp_templates` WRITE;
/*!40000 ALTER TABLE `whatsapp_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `whatsapp_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `wm_activity_logs`
--

DROP TABLE IF EXISTS `wm_activity_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `wm_activity_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `action` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`data`)),
  `ip_address` varchar(255) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `wm_activity_logs_user_id_foreign` (`user_id`),
  CONSTRAINT `wm_activity_logs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `wm_activity_logs`
--

LOCK TABLES `wm_activity_logs` WRITE;
/*!40000 ALTER TABLE `wm_activity_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `wm_activity_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'projectnow_'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-10-25 23:35:58
