<div class="container-fluid">
    <!-- Compact Single Section Design -->
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 20px; padding: 40px; color: white; position: relative; overflow: hidden; box-shadow: 0 20px 40px rgba(102, 126, 234, 0.3);">
                <!-- Background decorative elements -->
                <div style="position: absolute; top: -50px; right: -50px; width: 200px; height: 200px; background: rgba(255,255,255,0.1); border-radius: 50%;"></div>
                <div style="position: absolute; bottom: -30px; left: -30px; width: 120px; height: 120px; background: rgba(255,255,255,0.05); border-radius: 50%;"></div>
                
                <!-- Header Section -->
                <div class="row align-items-center mb-4">
                    <div class="col-md-8">
                        <div class="d-flex align-items-center">
                            <div style="width: 70px; height: 70px; background: rgba(255,255,255,0.2); border-radius: 15px; display: flex; align-items: center; justify-content: center; margin-right: 20px; backdrop-filter: blur(10px); border: 2px solid rgba(255,255,255,0.3);">
                                <i class="fas fa-certificate" style="font-size: 28px; color: #FFD700;"></i>
                            </div>
                            <div>
                                <h1 style="font-weight: 700; font-size: 2.2rem; margin-bottom: 5px;">OFFICIAL LICENSE</h1>
                                <p style="margin: 0; opacity: 0.9; font-size: 1.1rem;">FINAL by STATIXCODE - Licensed System</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4 text-end">
                        <div style="background: rgba(255,255,255,0.2); padding: 15px; border-radius: 12px; backdrop-filter: blur(15px); border: 2px solid rgba(255,255,255,0.3);">
                            <i class="fas fa-shield-alt" style="font-size: 32px; color: #28a745; margin-bottom: 8px;"></i>
                            <div style="font-weight: 700; font-size: 1.2rem;">VERIFIED</div>
                            <div style="font-weight: 500; opacity: 0.9; font-size: 0.9rem;">100% Official</div>
                            @if($verificationStatus === 'Verified')
                                <div style="margin-top: 8px; padding: 5px 10px; background: rgba(40, 167, 69, 0.3); border-radius: 20px; font-size: 0.8rem; font-weight: 600;">
                                    <i class="fab fa-whatsapp me-1"></i>WhatsApp Active
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Statistics Grid -->
                <div class="row">
                    <div class="col-lg-8">
                        <div style="background: rgba(255,255,255,0.15); border-radius: 15px; padding: 25px; backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.2);">
                            <h3 style="margin-bottom: 20px; font-weight: 600; font-size: 1.3rem;">
                                <i class="fas fa-chart-bar me-2"></i>
                                System Overview
                            </h3>
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <div style="text-align: center; padding: 15px; background: rgba(255,255,255,0.1); border-radius: 10px;">
                                        <i class="fas fa-users" style="font-size: 24px; color: #4facfe; margin-bottom: 8px;"></i>
                                        <div style="font-size: 1.8rem; font-weight: 700;">{{ $totalContacts ?? 0 }}</div>
                                        <div style="font-size: 0.85rem; opacity: 0.8;">Total Contacts</div>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <div style="text-align: center; padding: 15px; background: rgba(255,255,255,0.1); border-radius: 10px;">
                                        <i class="fas fa-paper-plane" style="font-size: 24px; color: #ffecd2; margin-bottom: 8px;"></i>
                                        <div style="font-size: 1.8rem; font-weight: 700;">{{ $totalCampaigns ?? 0 }}</div>
                                        <div style="font-size: 0.85rem; opacity: 0.8;">Total Campaigns</div>
                                    </div>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <div style="text-align: center; padding: 15px; background: rgba(255,255,255,0.1); border-radius: 10px;">
                                        <i class="fas fa-comments" style="font-size: 24px; color: #a8edea; margin-bottom: 8px;"></i>
                                        <div style="font-size: 1.8rem; font-weight: 700;">{{ $totalMessages ?? 0 }}</div>
                                        <div style="font-size: 0.85rem; opacity: 0.8;">Total Messages</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-lg-4">
                        <div style="background: rgba(255,255,255,0.15); border-radius: 15px; padding: 25px; backdrop-filter: blur(10px); border: 1px solid rgba(255,255,255,0.2);">
                            <h4 style="margin-bottom: 20px; font-weight: 600; font-size: 1.2rem;">
                                <i class="fas fa-cog me-2"></i>
                                System Status
                            </h4>
                            <div style="margin-bottom: 15px;">
                                <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                                    <span style="font-size: 0.9rem;">App:</span>
                                    <strong>{{ $appName ?? 'WhatsMark Pro' }}</strong>
                                </div>
                                <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                                    <span style="font-size: 0.9rem;">Version:</span>
                                    <strong>{{ $currentVersion ?? '1.0.4' }}</strong>
                                </div>
                                <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                                    <span style="font-size: 0.9rem;">Build:</span>
                                    <span style="font-size: 0.8rem; color: #FFD700;">{{ $buildVersion ?? 'Build ' . date('Y.m.d') . '.1' }}</span>
                                </div>
                                <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                                    <span style="font-size: 0.9rem;">Users:</span>
                                    <strong>{{ $totalUsers ?? 0 }}</strong>
                                </div>
                                <div style="display: flex; justify-content: space-between; margin-bottom: 5px;">
                                    <span style="font-size: 0.9rem;">Uptime:</span>
                                    <strong>{{ $systemUptime ?? '1 day' }}</strong>
                                </div>
                            </div>
                            
                            <!-- WhatsApp Verification Section -->
                            <div style="margin-top: 20px; padding-top: 15px; border-top: 1px solid rgba(255,255,255,0.2);">
                                <h5 style="margin-bottom: 12px; font-weight: 600; font-size: 1rem; color: #FFD700;">
                                    <i class="fab fa-whatsapp me-2"></i>
                                    WhatsApp Verification
                                </h5>
                                <div style="margin-bottom: 8px;">
                                    <div style="display: flex; justify-content: space-between; margin-bottom: 3px;">
                                        <span style="font-size: 0.85rem;">Status:</span>
                                        <span style="color: {{ $verificationStatus === 'Verified' ? '#28a745' : '#dc3545' }}; font-weight: 600; font-size: 0.85rem;">{{ $verificationStatus }}</span>
                                    </div>
                                    @if(!empty($verificationId))
                                        <div style="display: flex; justify-content: space-between; margin-bottom: 3px;">
                                            <span style="font-size: 0.85rem;">ID:</span>
                                            <span style="font-size: 0.75rem; font-family: monospace; opacity: 0.8;">
                                                {{ substr($verificationId, 0, 8) }}...{{ substr($verificationId, -8) }}
                                            </span>
                                        </div>
                                    @endif
                                    <div style="display: flex; justify-content: space-between; margin-bottom: 3px;">
                                        <span style="font-size: 0.85rem;">Last Check:</span>
                                        <span style="font-size: 0.8rem; color: #4facfe;">{{ $lastVerification ?? 'Never' }}</span>
                                    </div>
                                    @if(!empty($supportUntil))
                                        <div style="display: flex; justify-content: space-between;">
                                            <span style="font-size: 0.85rem;">Support:</span>
                                            <span style="font-size: 0.8rem; color: #ffecd2;">{{ $supportUntil }}</span>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            
                            <div style="text-align: center; margin-top: 20px; padding-top: 15px; border-top: 1px solid rgba(255,255,255,0.2);">
                                <i class="fas fa-trophy" style="font-size: 20px; color: #FFD700; margin-bottom: 8px;"></i>
                                <div style="font-weight: 600; font-size: 1rem;">FINAL by STATIXCODE</div>
                                <div style="font-size: 0.85rem; opacity: 0.8;">Licensed & Ready</div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Bottom License Banner -->
                <div class="text-center mt-4">
                    <div style="background: rgba(255,255,255,0.2); padding: 20px 30px; border-radius: 50px; display: inline-block; backdrop-filter: blur(10px); border: 2px solid rgba(255,255,255,0.3);">
                        <i class="fas fa-certificate" style="color: #FFD700; margin-right: 10px; font-size: 18px;"></i>
                        <strong style="font-size: 1.1rem;">OFFICIALLY LICENSED - FINAL by STATIXCODE</strong>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>