<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'inline' => true,
    'filter' => null,
    'tableName' => null,
    'multiple' => true,
    'initialValues' => [],
    'options' => [],
    'title' => '',
    'theme' => null,
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'inline' => true,
    'filter' => null,
    'tableName' => null,
    'multiple' => true,
    'initialValues' => [],
    'options' => [],
    'title' => '',
    'theme' => null,
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>

<?php
    $framework = config('livewire-powergrid.plugins.select');
    $collection = collect();

    if (filled(data_get($filter, 'dataSource'))) {
        $collection = collect(data_get($filter, 'dataSource'))
            ->transform(function (array|\Illuminate\Support\Collection|\Illuminate\Database\Eloquent\Model $entry) use ($filter) {
                if (is_array($entry)) {
                    $entry = collect($entry);
                }
            return $entry->only([data_get($filter, 'optionValue'), data_get($filter, 'optionLabel')]);
        });
    } elseif (filled(data_get($filter, 'computedDatasource'))) {
        $collection = collect(data_get($filter, 'computedDatasource'))
            ->transform(function (array|\Illuminate\Support\Collection|\Illuminate\Database\Eloquent\Model $entry) use ($filter) {
                if (is_array($entry)) {
                    $entry = collect($entry);
                }
            return $entry->only([data_get($filter, 'optionValue'), data_get($filter, 'optionLabel')]);
        });
    }

    $params = [
        'tableName' => $tableName,
        'label' => $title,
        'dataField' => data_get($filter, 'field'),
        'optionValue' => data_get($filter, 'optionValue'),
        'optionLabel' => data_get($filter, 'optionLabel'),
        'options' => data_get($filter, 'params'),
        'initialValues' => $initialValues,
        'framework' => $framework[config('livewire-powergrid.plugins.select.default')],
    ];

    if (\Illuminate\Support\Arr::has($filter, ['url', 'method'])) {
        $params['asyncData'] = [
            'url' => data_get($filter, 'url'),
            'method' => data_get($filter, 'method'),
            'parameters' => data_get($filter, 'parameters'),
            'headers' => data_get($filter, 'headers'),
        ];
    }

    $alpineData = $framework['default'] == 'tom' ? 'pgTomSelect(' . \Illuminate\Support\Js::from($params) . ')' : 'pgSlimSelect(' . \Illuminate\Support\Js::from($params) . ')';
?>
<div
    x-cloak
    wire:ignore
    x-data="<?php echo e($alpineData); ?>"
>
    <?php if(filled($filter)): ?>
        <div
            class="<?php echo e(theme_style($theme, 'filterSelect.base')); ?>"
        >
            <?php if(!$inline): ?>
                <label class="block text-sm font-medium text-gray-700 dark:text-gray-400">
                    <?php echo e($title); ?>

                </label>
            <?php endif; ?>
            <select
                <?php if($multiple): ?> multiple <?php endif; ?>
                class="<?php echo e(theme_style($theme, 'filterSelect.select')); ?>"
                wire:model="filters.multi_select.<?php echo e(data_get($filter, 'field')); ?>.values"
                x-ref="select_picker_<?php echo e(data_get($filter, 'field')); ?>_<?php echo e($tableName); ?>"
            >
                <?php if(!data_get($params, 'options.disableOptionAll', false)): ?>
                    <option value=""><?php echo e(trans('livewire-powergrid::datatable.multi_select.all')); ?></option>
                <?php endif; ?>

                <?php if(blank(data_get($params, 'asyncData', []))): ?>
                    <?php $__currentLoopData = $collection->toArray(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option wire:key="multi-select-option-<?php echo e($loop->index); ?>"
                                value="<?php echo e(data_get($item, data_get($filter, 'optionValue'))); ?>">
                            <?php echo e(data_get($item, data_get($filter, 'optionLabel'))); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </select>
        </div>
    <?php endif; ?>
</div>
<?php /**PATH C:\Users\corbital\Downloads\codecanyon-orVCxsZW-whatsmark-whatsapp-marketing-and-automation-platform-with-bots-chats-bulk-sender-ai\main-files\upload\upload\vendor\power-components\livewire-powergrid\resources\views\components\inputs\select.blade.php ENDPATH**/ ?>