<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Artisan;
use Symfony\Component\HttpFoundation\Response;

class CheckDatabaseVersion
{
    /**
     * Handle an incoming request.
     *
     * @param \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response) $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // BYPASSED - No database version checks
        // All installer and version checks have been removed
        
        if ($request->is('database-upgrade')) {
            return redirect()->route('admin.dashboard');
        }

        if ($request->is('upgrade')) {
            return $next($request);
        }

        // No upgrade checks - application is fully installed
        return $next($request);
    }
}