<div align="center">
   <p><a href="https://livewire-powergrid.com" target="_blank"><img src="art/header.jpg" alt="PowerGrid Logo"></a></p>
   <p align="center">
      <a href="https://packagist.org/packages/power-components/livewire-powergrid"><img alt="Latest Version" src="https://img.shields.io/static/v1?label=laravel&message=%E2%89%A510.0&color=0078BE&logo=laravel&style=flat-square"></a>
      <a href="https://packagist.org/packages/power-components/livewire-powergrid"><img alt="Total Downloads" src="https://img.shields.io/packagist/dt/power-components/livewire-powergrid"></a>
      <a href="https://github.com/Power-Components/livewire-powergrid/actions">
      <img alt="Tests Passing" src="https://github.com/Power-Components/livewire-powergrid/workflows/Powergrid%20Tests/badge.svg" /></a>
      <a href="https://packagist.org/packages/power-components/livewire-powergrid"><img alt="Latest Version" src="https://img.shields.io/packagist/v/power-components/livewire-powergrid"></a>
      <a href="https://packagist.org/packages/power-components/livewire-powergrid"><img alt="License" src="https://img.shields.io/packagist/l/power-components/livewire-powergrid"></a>
      <a href="https://packagist.org/packages/power-components/livewire-powergrid"><img alt="Last Commit" src="https://img.shields.io/github/last-commit/power-components/livewire-powergrid"></a>
   </p>
   <a href="https://livewire-powergrid.com" target="_blank">📚 Documentation</a> |
   <a href="#-online-interactive-demo" target="_blank"> 🚀 Online Demo</a> |
   <a href="#-features">🔥 Features</a> |
   <a href="#get-started">⌨️ Get started</a>
</div>

------

# ⚡ Livewire PowerGrid ⚡

<br/>

Livewire PowerGrid creates modern, powerful and easy-to-customize data tables based on [Laravel Livewire](https://laravel-livewire.com) library.

With PowerGrid, you can effortlessly create advanced data tables one in a matter of minutes.

<p>
    <a href="https://demo.livewire-powergrid.com/examples/demo-dish" target="_blank"><img src="https://livewire-powergrid.com/screenshot.png" alt="PowerGrid Screenshot" width="805"></a>
</p>

`🚀` **Minimal Configuration**

Tables have basic features activated by default. Ready to go!

`👍` **Minimal Configuration**

Extend and customize your Table including components (checkbox, action buttons, editable fields), global search feature, column data filters and data export tool.

`🛠️` **Minimal Configuration**

Table components include feature examples. Just uncomment some code, enter your data, and it works!

<br/>

## 🚀 Online Interactive Demo

Take a look at our Online Interactive Demo showcasing the latest PowerGrid features. Explore the source code, and get your Data Table up and running in no time.

`🌎` <a href="https://demo.livewire-powergrid.com" target="_blank">PowerGrid Online Demo</a>

<br/>

## 🔥 Features

PowerGrid offers a range of features that are readily available:

| Feature                                                            | PowerGrid                               |
| :--------------------------------------------------------------------- | :-------------------------------------- |
| Bootstrap 5 or Tailwind CSS 3x/4x                                      | ✅                                      |
| Pagination                                                             | ✅                                      |
| Column Sorting                                                         | ✅                                      |
| Filters & Global Search                                                | ✅                                      |
| Custom Filter Builder                                                  | ✅                                      |
| Inline Editing (Click to edit)                                         | ✅                                      |
| Row Buttons, Checkboxes, Dropdown menu, and Toggle Switch              | ✅                                      |
| Custom Cell Content (Links, images, currency formatting)               | ✅                                      |
| Multi-row Bulk Actions                                                 | ✅                                      |
| Conditional Action Rules for Rows, Buttons, and Checkboxes             | ✅                                      |
| Column Summaries (Sum, Count & Average)                                | ✅                                      |
| Data Export to XLSX/CSV (OpenSpout)                                    | ✅                                      |
| Queue Export for large datasets                                        | ✅                                      |
| Responsive                                                             | ✅                                      |
| Livewire Modal Integration (Wire Elements Modal)                       | ✅                                      |
| Multi Language                                                         | Available in 🇺🇸 🇧🇷 🇪🇸 🇮🇹 🇩🇪 and [more...](https://github.com/Power-Components/livewire-powergrid/tree/6.x/resources/lang) |

`📚` Learn more in our [Documentation](https://livewire-powergrid.com).

<br/>

## Get started

### Requirements

- PHP 8.2+
- [Laravel 10+](https://laravel.com/docs/installation)
- [Livewire 3.0x](https://livewire.laravel.com)
- [Tailwind 3x/4x](https://tailwindcss.com) or [Bootstrap 5](https://getbootstrap.com/docs/5.0/getting-started/introduction/)

<br/>

### Install PowerGrid

Require PowerGrid via [composer](https://getcomposer.org).

```bash
composer require power-components/livewire-powergrid
```

Then, follow the steps indicated in the [Documentation - Install page](https://livewire-powergrid.com/get-started/install.html).

<br/>

## Support & Community

`👥` **Interact with the PowerGrid community at our [Discussions](https://github.com/Power-Components/livewire-powergrid/discussions) tab.**

You can share ideas, find questions and answers, and collaborate with other PowerGrid users.

<br/>

`🛟` **For technical inquiries, bug reports, and feature requests, please use the [Issues](https://github.com/Power-Components/livewire-powergrid/issues) tab.**

Please look into our previous Issues and Discussions before submitting a new issue.

<br/>

## Contribute

`🙏` **You can help PowerGrid in a number of ways; contributing goes beyond writing code.**

Please read the [Contributing Guide](CONTRIBUTING.md) to see what kind of contributions you can make and what steps you should follow.

<br/>

## Credits

- Created by [Luan Freitas](https://twitter.com/luanfreitasdev) and [@DanSysAnalyst](https://github.com/dansysanalyst)
- [All Contributors](../../contributors)
- Logo & artwork by [Caneco](https://twitter.com/caneco)

<hr>

<p>Sponsored by:</p>
<p>
  <!--DevSquad-->
  <a href="https://devsquad.com" target="_blank">
    <img src="https://livewire-powergrid.com/sponsors/devsquad.png" alt="DevSquad" height="64">
  </a>
</p>

<p></p>
<p></p>

<p>With the support of:</p>
<p>
  <!-- PHPStorm -->
  <a href="https://www.jetbrains.com/phpstorm/" target="_blank">
    <img src="https://livewire-powergrid.com/sponsors/phpstorm.png" alt="PHPStorm" height="32">
  </a>
  <!-- Araxis Merge -->
  <a href="https://www.araxis.com/merge/" target="_blank">
    <img src="https://livewire-powergrid.com/sponsors/araxis.png" alt="Araxis Merge" height="32">
  </a>
</p>

<hr>

<sup><b>Notice of Non-Affiliation and Disclaimer:</b> Livewire PowerGrid is not affiliated with, associated with, endorsed by, or in any way officially connected with the <a href="https://laravel-livewire.com" target="_blank">Laravel Livewire</a> - copyright by Caleb Porzio. Laravel is a trademark of Taylor Otwell.</sup>
